#
# Dark Channel Block Utilities Library
#
# Copyright (C) 2015 by DataCore GmbH
#     Amir Guindehi <amir@datacore.ch>
#

package DarkChannel::Utils::Block;

use warnings;
use strict;

use Carp;
use Data::Dumper;

use DarkChannel::Utils::Log;

use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

our $VERSION = 1.00;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw();
our @EXPORT = qw( dc_block_split_last );

sub dc_block_split_last($$)
{
    my $CONF = shift;
    my $data = shift;

    my $idx;
    my $body = undef;
    my $block = undef;

    # find last block start (single - on a line) index
    my @lines = split(/\n/, $data);
    for my $i ( -$#lines..0 )
    {
        $idx = -$i;
        last if ($lines[$idx] =~ /^-$/);
    }
    if ($idx && ($lines[$idx] =~ /^-$/))
    {
        # found single - on a line
        my @blines = splice(@lines, $idx + 1); # removes everything after single - from @lines
        pop(@lines); # remove single - from @lines
        $body = join("\n", @lines);
        $block = join("\n", @blines);
    }
    else
    {
        # could not find single - on a line, this is the last block
        $block = $data;
    }

    dc_log_dbg($body, 'Split Block: Body') if ($body && $CONF->{log}->{log_dbg_splitblock});
    dc_log_dbg($block, 'Split Block: Block') if ($block && $CONF->{log}->{log_dbg_splitblock});

    return ($body, $block);
}

1;
