#
# Dark Channel Terminal Command Library
#
# Copyright (C) 2015 by DataCore GmbH
#     Amir Guindehi <amir@datacore.ch>
#

package DarkChannel::Node::Client::Term::History;

use warnings;
use strict;

use Carp;
use Data::Dumper;

use DarkChannel::Utils::Log;

use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

our $VERSION = 1.00;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw();
our @EXPORT = qw( dc_poe_term_cmd_history_push
                  dc_poe_term_cmd_history_next
                  dc_poe_term_cmd_history_prev );

my @CMD = ();
my $CMD_MAX = 20;
my $CMD_CUR = 0;

sub dc_poe_term_cmd_history_push($)
{
    my $cmd = shift;

    unshift(@CMD, $cmd);
    pop(@CMD) if (@CMD > $CMD_MAX);
    return;
}

sub dc_poe_term_cmd_history($$)
{
    my ($cnt, $old) = @_;

    confess('$cnd != [-1, 0, +1] in dc_poe_term_cmd_history()') if(($cnt < -1) || ($cnt > 1));

    # push input line if not yet in history
    if (($CMD_CUR <= 0) && ($CMD[0] ne $old)) {
        dc_poe_term_cmd_history_push($old) if ($old ne '');
        #$cnt = 0 if ($old eq '');
        $CMD_CUR = -1 if ($CMD_CUR < 0);
        $cnt = 2 if (($cnt == 1) && ($CMD_CUR < 0));
    }

    # change history index
    $CMD_CUR += $cnt;

    # handle max/min
    $CMD_CUR = $#CMD if ($CMD_CUR > $#CMD);
    $CMD_CUR = -1, return '' if ($CMD_CUR < 0);

    # return historic command
    return $CMD[$CMD_CUR];
}

sub dc_poe_term_cmd_history_next($)
{
    my $editor = shift;

    $editor->text(dc_poe_term_cmd_history(-1, $editor->text()));
    $editor->cursor_to_end();
}

sub dc_poe_term_cmd_history_prev($)
{
    my $editor = shift;

    $editor->text(dc_poe_term_cmd_history(1, $editor->text()));
    $editor->cursor_to_end();
}

1;
