#
# Dark Channel Client Default Conf Library
#
# Copyright (C) 2015 by DataCore GmbH
#     Amir Guindehi <amir@datacore.ch>
#

package DarkChannel::Node::Client::Conf::Defaults;

use warnings;
use strict;

use Carp;
use Data::Dumper;

use Tie::IxHash;

use Exporter;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $conf);

our $VERSION = 1.00;
our @ISA = qw( Exporter );
our @EXPORT_OK = qw();
our @EXPORT = qw( %CONF_DEFAULT $CONF_DEFAULT_NAME $CONF_DEFAULT_DIR);

# conf default name & path
our $CONF_DEFAULT_NAME = 'dcc.conf';
our $CONF_DEFAULT_DIR = $ENV{HOME} . '/.darkchannel/client';

# conf defaults
tie my %CONF_DEFAULT_GPG_EXECUTABLES, "Tie::IxHash";
%CONF_DEFAULT_GPG_EXECUTABLES =
(
    gpg                   => '/usr/bin/gpg',
    gpg_agent             => '/usr/bin/gpg-agent',
    gpg_connect_agent     => '/usr/bin/gpg-connect-agent',
    gpg_preset_passphrase => '/usr/libexec/gpg-preset-passphrase',
);
tie my %CONF_DEFAULT_GPG, "Tie::IxHash";
%CONF_DEFAULT_GPG =
(
    gpg_storage_mode      => 0700,
    gpg_keylength         => 2048, # 1024, 2048, 4096
    gpg_logfile           => 0,    # 'log/gpg.log'
    gpg_passphrase        => 'abc',
    gpg_executables       => \%CONF_DEFAULT_GPG_EXECUTABLES,
);
tie my %CONF_DEFAULT_LOG, "Tie::IxHash";
%CONF_DEFAULT_LOG =
(
    log_crit => 1,
    log_err  => 1,
    log_warn => 1,
    log_info => 1,
    log_dbg  => 1,

    log_dbg_transition         => 1,
    log_dbg_interpreter        => 1,
    log_dbg_verify             => 1,
    log_dbg_request            => 1,
    log_dbg_response           => 1,
    log_dbg_request_transport  => 0,
    log_dbg_response_transport => 0,
    log_dbg_splitblock         => 0,
    log_dbg_input              => 0,

    log_dbg_gpg                => 1,
    log_dbg_gpg_keygen         => 0,
    log_dbg_gpg_keyinfo        => 0,
    log_dbg_gpg_sign           => 0,
    log_dbg_gpg_encrypt        => 0,
    log_dbg_gpg_decrypt        => 0,
    log_dbg_gpg_verify         => 0,
    log_dbg_gpg_import         => 0,
    log_dbg_gpg_export         => 0,
    log_dbg_gpg_inspect        => 0,
    log_dbg_gpg_key_sign       => 0,
    log_dbg_gpg_key_trust      => 0,
    log_dbg_gpg_exec           => 1,

    log_dbg_session_curses            => 0,
    log_dbg_session_terminal          => 0,
    log_dbg_session_interpreter       => 1,
    log_dbg_session_channelserver_tcp => 1,

    log_dbg_session_core_ircd         => 1, # show raw ircd commands
    log_dbg_session_core_ircd_auth    => 0,
    log_dbg_session_core_ircd_event   => 0,
    log_dbg_session_core_ircd_output  => 0,
    log_dbg_session_core_irc_proto    => 0, # needs log_dbg_request/log_dbg_response, shows on irc client

    logfile => 'log/dcc.log',
);
tie my %CONF_DEFAULT_SETTINGS, "Tie::IxHash";
%CONF_DEFAULT_SETTINGS =
(
    enable_terminal => 1,
    enable_ircd_core => 1,
    confirm_quit => 0,
    buffer_size => 32768,
    transport_encryption => 1,
);
tie my %CONF_DEFAULT_NODE_CHANNELSERVER_DEFAULT, "Tie::IxHash";
%CONF_DEFAULT_NODE_CHANNELSERVER_DEFAULT =
(
    host => 'localhost',
    port => 26667,
    key_id => 0,

);
tie my %CONF_DEFAULT_NODE_CORE_IRCD_DEFAULT, "Tie::IxHash";
%CONF_DEFAULT_NODE_CORE_IRCD_DEFAULT =
(
    bind_host => 'localhost',
    bind_port => 6697,

    server_name => 'darkchannel.net',
    server_description => 'A DarkChannel Core Server for darkchannel.net',
    server_network => 'DarkChannel.NET',
    server_info => "DarkChannel Core Server|Copyright (C) 2015 by DataCore GmbH, Amir Guindehi",
    server_admin => "DataCore GmbH|Amir Guindehi|amir\@darkchannel.ch",
    server_motd => "Welcome to this DarkChannel Core!|" .
                   "This core will connect your IRC client to DarkChannel|" .
                   " channel servers around the globe.",
    server_prefix => '***',

    # SSL support, this feature needs POE::Component::SSLify (see SSLify options for usage)
    server_ssl_key => '../ssl/darkchannel.ch.pem',
    server_ssl_crt => '../ssl/darkchannel.ch.crt',
    server_ssl_ver => 'default',
    #server_ssl_opt => Net::SSLeay::OP_ALL,
);
tie my %CONF_DEFAULT_NODE_CHANNELSERVER, "Tie::IxHash";
%CONF_DEFAULT_NODE_CHANNELSERVER =
(
   _default => \%CONF_DEFAULT_NODE_CHANNELSERVER_DEFAULT,
);
tie my %CONF_DEFAULT_NODE_CORE_IRCD, "Tie::IxHash";
%CONF_DEFAULT_NODE_CORE_IRCD =
(
   _default => \%CONF_DEFAULT_NODE_CORE_IRCD_DEFAULT,
);
tie my %CONF_DEFAULT_NODE_CORE, "Tie::IxHash";
%CONF_DEFAULT_NODE_CORE =
(
   ircd => \%CONF_DEFAULT_NODE_CORE_IRCD
);
tie my %CONF_DEFAULT_NODE, "Tie::IxHash";
%CONF_DEFAULT_NODE =
(
    channelserver => \%CONF_DEFAULT_NODE_CHANNELSERVER,
    core => \%CONF_DEFAULT_NODE_CORE,
);
tie my %CONF_DEFAULT_CLIENT, "Tie::IxHash";
%CONF_DEFAULT_CLIENT =
(
    product_name => 'DarkChannel',
    service_name => 'Client',
    protocol_version => 'v1',
    client_type => 'Linux/Perl',

    node     => \%CONF_DEFAULT_NODE,
    gpg      => \%CONF_DEFAULT_GPG,
    log      => \%CONF_DEFAULT_LOG,
    settings => \%CONF_DEFAULT_SETTINGS,
);
tie our %CONF_DEFAULT, "Tie::IxHash";
%CONF_DEFAULT =
(
    client => \%CONF_DEFAULT_CLIENT,
);

1;
