use ExtUtils::MakeMaker;

WriteMakefile(
    NAME          => 'DarkChannel',
    ABSTRACT      => 'A reference implementation of the DarkChannel Chat Protocol Specification',
    AUTHOR        => [ 'Amir Guindehi', 'amir@datacore.ch' ],
    DISTNAME      => 'darkchannel',
    VERSION_FROM  => 'lib/DarkChannel/Version.pm',
    EXE_FILES     => [ 'bin/dcc', 'bin/dcd' ],
    PREREQ_PM     => { 'POE'                                   => '1.356',
                       'POE::API::Peek'                        => '2.200.0',
                       'POE::Component::Client::TCP'           => 0,
                       'POE::Component::Server::TCP'           => 0,
                       'POE::Component::Server::IRC'           => 0,
                       'POE::Component::SSLify'                => 0,
                       'POE::Component::Syndicator'            => 0,
                       'POE::Component::Client::Ident'         => 0,
                       'POE::Component::Client::DNS'           => 0,
                       'Curses'                                => '1.280.0',
                       'Curses::UI::POE'                       => '0.040',
                       'Curses::UI::Widget'                    => '1.12',
                       'IPC::Run3'                             => '0.045',
                       'IO::Pipely'                            => '0.005.0',
                       'CryptX'                                => '0.021',
                       'Crypt::Eksblowfish::Bcrypt'            => 0,
                       'Config::General'                       => 0,
                       'Tie::IxHash'                           => 0,
                       'POSIX'                                 => 0,
                       'Module::Build::Tiny'                   => 0,
                       'IRC::Utils'                            => 0,
                       'Net::Netmask'                          => 0,
                       'Getopt::Long'                          => 0,
                       'Exporter'                              => 0,
                       'FileHandle'                            => 0,
                       'File::Path'                            => 0,
                       'File::Which'                           => 0,
                       'Data::Dumper'                          => 0,
                       'Carp'                                  => 0,

    },
);
